/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.messagevortex.MessageVortexLogger;

public class Config {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final String DEFAULT = "default";
    private final List<String> sections = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private String resourceFilename;
    static Config defaultConfig = null;
    private final Map<String, ConfigElement> configData = new ConcurrentHashMap<String, ConfigElement>();

    private Config() {
    }

    public Config(String ressourceFile) throws IOException {
        this();
        if (ressourceFile != null) {
            this.readRessources(ressourceFile);
        }
    }

    private void setResouceFilename(String ressouceFilename) {
        this.resourceFilename = ressouceFilename;
    }

    public String getResouceFilename() {
        return this.resourceFilename;
    }

    private void readRessources(String resourceFile) throws IOException {
        if (resourceFile == null) {
            throw new IOException("resource file name may not be null");
        }
        this.setResouceFilename(resourceFile);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resourceFile), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                if (!Pattern.matches("\\s*//.*", line) && !Pattern.matches("\\s*", line)) {
                    try (Scanner scanner = new Scanner(line);){
                        scanner.useDelimiter("\\s*;\\s*");
                        block27: while (scanner.hasNext()) {
                            String token = scanner.next().trim();
                            switch (token.toLowerCase()) {
                                case "boolean": {
                                    String name = scanner.next().trim();
                                    boolean bval = "true".equals(scanner.next().toLowerCase().trim());
                                    String desc = scanner.next().trim();
                                    this.createBooleanConfigValue(name, desc, bval);
                                    continue block27;
                                }
                                case "string": {
                                    String name = scanner.next().trim();
                                    String sval = scanner.next().trim();
                                    if ("".equals(sval)) {
                                        sval = null;
                                    }
                                    String desc = scanner.next().trim();
                                    this.createStringConfigValue(name, desc, sval);
                                    continue block27;
                                }
                                case "numeric": {
                                    String name = scanner.next().trim();
                                    int ival = Integer.parseInt(scanner.next().trim());
                                    String desc = scanner.next().trim();
                                    this.createNumericConfigValue(name, desc, ival);
                                    continue block27;
                                }
                                case "section_list": {
                                    String name = scanner.next().trim();
                                    String seclval = scanner.next().trim();
                                    if ("".equals(seclval)) {
                                        seclval = null;
                                    }
                                    String desc = scanner.next().trim();
                                    this.createSectionListConfigValue(name, desc, seclval);
                                    continue block27;
                                }
                                case "section": {
                                    String name = scanner.next().trim();
                                    String secval = scanner.next().trim();
                                    if ("".equals(secval)) {
                                        secval = null;
                                    }
                                    String desc = scanner.next().trim();
                                    this.createSectionConfigValue(name, desc, secval);
                                    continue block27;
                                }
                            }
                            throw new IOException("encountered unknown field type: " + token + " (line was \"" + line + "\")");
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (NullPointerException npe) {
            throw new IOException("unable to read resource file " + resourceFile, npe);
        }
    }

    public static Config getDefault() throws IOException {
        return Config.createConfig(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config copy() {
        Config dst = new Config();
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            Set<Map.Entry<String, ConfigElement>> it = this.configData.entrySet();
            for (Map.Entry<String, ConfigElement> p : it) {
                dst.configData.put(p.getKey(), p.getValue().copy());
            }
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            Set<Map.Entry<String, ConfigElement>> it = this.configData.entrySet();
            for (Map.Entry<String, ConfigElement> p : it) {
                p.getValue().unset(null);
            }
        }
    }

    private String setValue(String section, String id, String value, int lineNumber) throws IOException {
        ConfigElement c = this.configData.get(id.toLowerCase());
        if (c == null) {
            throw new IOException("unknown key \"" + id + "\" when setting value");
        }
        String ret = c.getValue(section);
        if (c.getType() == ConfigType.NUMERIC) {
            this.setNumericValue(section, id, Integer.parseInt(value), lineNumber);
        } else if (c.getType() == ConfigType.BOOLEAN) {
            this.setBooleanValue(section, id, "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value), lineNumber);
        } else if (c.getType() == ConfigType.STRING) {
            this.setStringValue(section, id, value, lineNumber);
        } else if (c.getType() == ConfigType.SECTION_LIST) {
            this.setSectionListValue(section, id, value, lineNumber);
        } else if (c.getType() == ConfigType.SECTION) {
            this.setSectionValue(section, id, value, lineNumber);
        } else {
            throw new NullPointerException("type not implemented");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBooleanConfigValue(String id, String description, boolean dval) {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            if (this.configData.get(id.toLowerCase()) != null) {
                throw new IllegalArgumentException("id \"" + id + "\" is already defined");
            }
            ConfigElement ele = new ConfigElement(id, "boolean", description);
            this.configData.put(id.toLowerCase(), ele);
            ele.setDefaultValue(dval ? "true" : "false");
            LOGGER.log(Level.FINE, "Created boolean config variable " + id.toLowerCase());
            this.fields.add(id.toLowerCase());
        }
    }

    private static synchronized Config createConfig(String res) throws IOException {
        if (defaultConfig == null) {
            defaultConfig = new Config(res);
        }
        return defaultConfig;
    }

    public boolean setBooleanValue(String section, String id, boolean value, int lineNumber) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("id " + id + " is not known to the config subsystem");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.BOOLEAN) {
            throw new ClassCastException("config type missmatch when accessing ID " + id + " (expected: boolean; is: " + type.name() + ")");
        }
        return ele.setBooleanValue(section, value, lineNumber);
    }

    public boolean getBooleanValue(String section, String id) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("id " + id + " is not known to the config subsystem");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.BOOLEAN) {
            throw new ClassCastException("config type missmatch when accessing ID " + id + " (expected: boolean; is: " + type.name() + ")");
        }
        return ele.getBooleanValue(section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNumericConfigValue(String id, String description, int dval) {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            if (this.configData.get(id.toLowerCase()) != null) {
                throw new IllegalArgumentException("id \"" + id + "\" is already defined");
            }
            ConfigElement ele = new ConfigElement(id, "numeric", description, "" + dval);
            this.configData.put(id.toLowerCase(), ele);
            LOGGER.log(Level.FINE, "Created numeric config variable " + id.toLowerCase() + "[numeric]=" + dval);
            this.fields.add(id.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSectionConfigValue(String id, String description, String dval) {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            if (this.configData.get(id.toLowerCase()) != null) {
                throw new IllegalArgumentException("id \"" + id + "\" is already defined");
            }
            ConfigElement ele = new ConfigElement(id, "section", description, dval);
            this.configData.put(id.toLowerCase(), ele);
            LOGGER.log(Level.FINE, "Created section config variable " + id.toLowerCase() + "[section]=" + dval);
            this.fields.add(id.toLowerCase());
        }
    }

    public int setNumericValue(String section, String id, int value, int lineNumber) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("id " + id + " is not known to the config subsystem");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.NUMERIC) {
            throw new ClassCastException("config type missmatch when accessing ID " + id + " (expected: numeric; is: " + type.name() + ")");
        }
        return ele.setNumericValue(section, value, lineNumber);
    }

    public int getNumericValue(String section, String id) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("id " + id + " is not known to the config subsystem");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.NUMERIC) {
            throw new ClassCastException("config type missmatch when accessing ID " + id + " (expected: numeric; is: " + type.name() + ")");
        }
        return ele.getNumericValue(section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSectionListConfigValue(String id, String description, String dval) {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            if (this.configData.get(id.toLowerCase()) == null) {
                ConfigElement ele = new ConfigElement(id, "section_list", description);
                this.configData.put(id.toLowerCase(), ele);
                ele.setDefaultValue(dval);
                LOGGER.log(Level.FINE, "Created section_list config variable " + id.toLowerCase());
                this.fields.add(id.toLowerCase());
                return true;
            }
            return false;
        }
    }

    public String setSectionListValue(String section, String id, String value, int lineNumber) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("unable to get id " + id + " from config subsystem");
        }
        if (value == null) {
            throw new NullPointerException("unable to set id " + id + " of config subsystem (value may not be null)");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.SECTION_LIST) {
            throw new ClassCastException("Unable to cast type to correct class (" + type.name() + " is not section_list)");
        }
        return ele.setSectionListValue(section, value, lineNumber);
    }

    public String[] getSectionListValue(String section, String id) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("unable to get id " + id + " from config subsystem (unknown element)");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.SECTION_LIST) {
            throw new ClassCastException("Unable to cast type to correct class (" + type.name() + " is not typed section_list)");
        }
        String secList = ele.getSectionListValue(section);
        if (secList == null) {
            return new String[0];
        }
        return secList.split("\\s*,\\s*");
    }

    public String setSectionValue(String section, String id, String value, int lineNumber) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("unable to get id " + id + " from config subsystem");
        }
        if (value == null) {
            throw new NullPointerException("unable to set id " + id + " of config subsystem (value may not be null)");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.SECTION) {
            throw new ClassCastException("Unable to cast type to correct class (expected: section; is: " + type.name() + ")");
        }
        return ele.setSectionListValue(section, value, lineNumber);
    }

    public String getSectionValue(String section, String id) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("unable to get value for \"" + id + "\" from config subsystem (unknown element in section \"" + section + "\")");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.SECTION) {
            throw new ClassCastException("Unable to cast type to correct class (expected: section; is: " + type.name() + ")");
        }
        return ele.getSectionValue(section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStringConfigValue(String id, String description, String dval) {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            if (this.configData.get(id.toLowerCase()) == null) {
                ConfigElement ele = new ConfigElement(id, "STRING", description);
                this.configData.put(id.toLowerCase(), ele);
                ele.setDefaultValue(dval);
                LOGGER.log(Level.FINE, "Created String config variable " + id.toLowerCase());
                this.fields.add(id.toLowerCase());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfigValue(String id) {
        Map<String, ConfigElement> map = this.configData;
        synchronized (map) {
            if (this.configData.get(id.toLowerCase()) == null) {
                return false;
            }
            this.configData.remove(id.toLowerCase());
            this.fields.remove(id.toLowerCase());
            return true;
        }
    }

    public String setStringValue(String section, String id, String value, int lineNumber) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null || value == null) {
            throw new NullPointerException("unable to get id " + id + " from config subsystem");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.STRING) {
            throw new ClassCastException("Unable to cast type to correct class (expected: string; is: " + type.name() + ")");
        }
        return ele.setStringValue(section, value, lineNumber);
    }

    public String getStringValue(String section, String id) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("unable to get id " + id + " from config subsystem (unknown element)");
        }
        ConfigType type = ele.getType();
        if (type != ConfigType.STRING) {
            throw new ClassCastException("Unable to cast type to correct class (expected: string; is: " + type.name() + ")");
        }
        return ele.getStringValue(section);
    }

    public boolean isDefaultValue(String section, String id) {
        ConfigElement ele = this.configData.get(id.toLowerCase());
        if (ele == null) {
            throw new NullPointerException("unable to get id " + id + " from config subsystem (unknown element)");
        }
        return ele.getValueSource(section) == ConfigSource.DEFAULT_VALUE;
    }

    public Map<String, ConfigElement> getMap() {
        return this.configData;
    }

    public void load(String filename) throws IOException {
        Pattern sectionPat = Pattern.compile("^\\s*\\[([a-zA-Z0-9_\\-]+)\\]\\s*$");
        Pattern keyValuePat = Pattern.compile("^\\s*([^=]+)\\s*=\\s*(.*)\\s*$");
        InputStream fstream = this.getClass().getClassLoader().getResourceAsStream(filename);
        if (fstream == null) {
            try {
                fstream = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.log(Level.WARNING, "Unable to load config file \"" + filename + "\"", fnfe);
                throw fnfe;
            }
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fstream, StandardCharsets.UTF_8));){
            String line;
            String section = null;
            int lineCounter = 1;
            while ((line = br.readLine()) != null) {
                if (!Pattern.matches("\\s*//.*", line) && !Pattern.matches("\\s*", line)) {
                    Matcher m = sectionPat.matcher(line);
                    if (m.matches()) {
                        section = m.group(1);
                        LOGGER.log(Level.FINE, "parsing section [" + section + "]");
                    } else {
                        m = keyValuePat.matcher(line);
                        if (m.matches()) {
                            String key = m.group(1).trim();
                            String value = m.group(2).trim();
                            this.setValue(section, key, value, lineCounter);
                        } else {
                            throw new IOException("unable to parse \"" + line + "\" (line:" + lineCounter + ")");
                        }
                    }
                }
                ++lineCounter;
            }
        }
    }

    public String store() throws IOException {
        StringWriter bw = new StringWriter();
        this.store(bw);
        bw.close();
        return bw.toString();
    }

    public void store(String filename) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            this.store(bw);
        }
    }

    private void store(Writer bw) throws IOException {
        bw.write("[default]" + System.lineSeparator());
        this.dumpSection(null, bw, true);
        for (String section : this.sections) {
            bw.write(System.lineSeparator() + "[" + section + "]" + System.lineSeparator());
            this.dumpSection(section, bw, false);
        }
    }

    public String getDescription(String id) {
        ConfigElement c = this.configData.get(id.toLowerCase());
        return c == null ? null : c.getDescription();
    }

    private String getValue(String section, String id) {
        ConfigElement c = this.configData.get(id.toLowerCase());
        return c == null ? null : c.getValue(section);
    }

    public String getDefaultValue(String id) {
        ConfigElement c = this.configData.get(id.toLowerCase());
        return c == null ? null : c.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSection(String section, Writer w, boolean withComments) throws IOException {
        for (String field : this.fields) {
            Map<String, ConfigElement> map = this.configData;
            synchronized (map) {
                if (this.configData.get(field.toLowerCase()) == null) {
                    throw new IOException("inconsistency deteceted in internal storage when querying field " + field);
                }
            }
            if (withComments) {
                w.write("// ******************************************************************************" + System.lineSeparator());
                w.write("// name: " + field + System.lineSeparator());
                w.write("// ******************************************************************************" + System.lineSeparator());
                w.write(Config.wrap("// ", this.getDescription(field), 77) + System.lineSeparator());
                w.write("// ******************************************************************************" + System.lineSeparator());
                w.write("// default: " + this.getDefaultValue(field) + System.lineSeparator());
            }
            if (this.configData.get(field.toLowerCase()).getValueSource(section) == ConfigSource.SECTION) {
                w.write(field + " = " + this.getValue(section, field) + System.lineSeparator());
            }
            if (!withComments) continue;
            w.write(System.lineSeparator());
        }
    }

    private static String wrap(String prefix, String string, int lineLength) {
        StringBuilder b = new StringBuilder();
        for (String line : string.split(Pattern.quote(System.lineSeparator()))) {
            b.append(Config.wrapLine(prefix, line, lineLength));
        }
        return b.toString();
    }

    private static String wrapLine(String prefix, String line, int lineLength) {
        if (line.length() == 0) {
            return "";
        }
        if (line.length() <= lineLength) {
            return prefix + line;
        }
        String[] words = line.split(" ");
        StringBuilder allLines = new StringBuilder();
        StringBuilder trimmedLine = new StringBuilder().append(prefix);
        for (String word : words) {
            if (trimmedLine.length() + 1 + word.length() <= lineLength) {
                trimmedLine.append(word).append(' ');
                continue;
            }
            allLines.append((CharSequence)trimmedLine).append(System.lineSeparator());
            trimmedLine = new StringBuilder().append(prefix);
            trimmedLine.append(word).append(' ');
        }
        if (trimmedLine.length() > 0) {
            allLines.append((CharSequence)trimmedLine);
        }
        return allLines.toString();
    }

    private class ConfigElement
    implements Comparator<ConfigElement> {
        private String id;
        private String type;
        private String description;
        private String defaultValue;
        private Map<String, ConfigValue> currentValue = new HashMap<String, ConfigValue>();

        ConfigElement(String id, String type) {
            this.setId(id);
            this.setType(type);
            this.setDefaultValue(null);
            this.setDescription(null);
        }

        ConfigElement(String id, String type, String description) {
            this(id, type);
            this.setDescription(description);
        }

        ConfigElement(String id, String type, String description, String defValue) {
            this(id, type, description);
            this.setDefaultValue(defValue);
        }

        public ConfigElement copy() {
            ConfigElement ret = new ConfigElement(this.id, this.type, this.description);
            ret.defaultValue = this.defaultValue;
            ret.currentValue = new HashMap<String, ConfigValue>(this.currentValue.size());
            for (Map.Entry<String, ConfigValue> e : this.currentValue.entrySet()) {
                ret.currentValue.put(e.getKey(), e.getValue().copy());
            }
            return ret;
        }

        public final void setId(String id) {
            if (id == null) {
                throw new NullPointerException("id must not be null");
            }
            this.id = id.toLowerCase();
        }

        public final void setType(String type) {
            if (type == null) {
                throw new NullPointerException("type must not be null");
            }
            if (ConfigType.getById(type) == null) {
                throw new IllegalArgumentException("type " + type + " is not a known config type");
            }
            this.type = type.toLowerCase();
        }

        public final ConfigType getType() {
            return ConfigType.getById(this.type);
        }

        final void setDescription(String description) {
            this.description = description;
        }

        final String getDescription() {
            return this.description;
        }

        private String setValue(String section, String value, int lineNumber) {
            String ret;
            if (section == null) {
                section = Config.DEFAULT;
            }
            if (!Config.this.sections.contains(section) && !Config.DEFAULT.equals(section)) {
                Config.this.sections.add(section);
            }
            if ((ret = this.getValue(section)) == null) {
                LOGGER.log(Level.FINE, "value for " + this.id + " is set to " + value);
            } else {
                LOGGER.log(Level.FINE, "value for " + this.id + " is modified to " + value);
            }
            if (value != null) {
                this.currentValue.put(section, new ConfigValue(value, lineNumber));
            } else {
                this.currentValue.remove(section);
            }
            return ret;
        }

        private String getValue(String section) {
            if (section == null) {
                section = Config.DEFAULT;
            }
            String ret = this.currentValue.get(section) != null ? this.currentValue.get(section).getValue() : (this.currentValue.get(Config.DEFAULT) != null ? this.currentValue.get(Config.DEFAULT).getValue() : this.defaultValue);
            return ret;
        }

        private ConfigSource getValueSource(String section) {
            if (section == null) {
                section = Config.DEFAULT;
            }
            ConfigSource ret = this.currentValue.get(section) != null ? ConfigSource.SECTION : (this.currentValue.get(Config.DEFAULT) != null ? ConfigSource.DEFAULT_SECTION : ConfigSource.DEFAULT_VALUE);
            return ret;
        }

        private String getDefaultValue() {
            return this.defaultValue;
        }

        public final String getStringValue(String section) {
            return (String)this.getType().getConverters().stringToObject(this.getValue(section));
        }

        public final String setStringValue(String section, String value, int lineNumber) {
            String ret = this.getStringValue(section);
            this.setValue(section, this.getType().getConverters().objectToString(value), lineNumber);
            return ret;
        }

        public final String getSectionListValue(String section) {
            return (String)this.getType().getConverters().stringToObject(this.getValue(section));
        }

        public final String setSectionListValue(String section, String value, int lineNumber) {
            String ret = this.getStringValue(section);
            this.setValue(section, this.getType().getConverters().objectToString(value), lineNumber);
            return ret;
        }

        public final String getSectionValue(String section) {
            return (String)this.getType().getConverters().stringToObject(this.getValue(section));
        }

        public final String setSectionValue(String section, String value, int lineNumber) {
            String ret = this.getStringValue(section);
            this.setValue(section, this.getType().getConverters().objectToString(value), lineNumber);
            return ret;
        }

        public final boolean getBooleanValue(String section) {
            return (Boolean)this.getType().getConverters().stringToObject(this.getValue(section));
        }

        public final boolean setBooleanValue(String section, boolean value, int lineNumber) {
            boolean ret = this.getBooleanValue(section);
            this.setValue(section, this.getType().getConverters().objectToString(value), lineNumber);
            return ret;
        }

        public final int getNumericValue(String section) {
            try {
                return (Integer)this.getType().getConverters().stringToObject(this.getValue(section));
            }
            catch (IllegalArgumentException ae) {
                LOGGER.log(Level.SEVERE, "Unable to parse " + this.id + "[" + this.type + "; section:" + section + "]=" + this.getValue(section) + "] as int (def:" + this.defaultValue + "/curr:" + this.getValue(section) + ")", ae);
                throw ae;
            }
        }

        public final int setNumericValue(String section, int value, int lineNumber) {
            int ret = this.getNumericValue(section);
            this.setValue(section, this.getType().getConverters().objectToString(value), lineNumber);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String unset(String section) {
            LOGGER.log(Level.FINE, "value for " + this.id + " is deleted (unset called)");
            Map<String, ConfigValue> map = this.currentValue;
            synchronized (map) {
                if (section == null) {
                    for (String s : this.currentValue.keySet().toArray(new String[0])) {
                        this.setValue(s, null, -1);
                    }
                    return null;
                }
                return this.setValue(section, null, -1);
            }
        }

        @Override
        public int compare(ConfigElement o1, ConfigElement o2) {
            return o1.id.compareToIgnoreCase(o2.id);
        }

        public final void setDefaultValue(String newDefaultValue) {
            this.defaultValue = newDefaultValue;
            LOGGER.log(Level.FINE, "Default value set to " + this.id + "=" + this.defaultValue);
        }
    }

    private static enum ConfigType {
        BOOLEAN(new BooleanConverters()),
        NUMERIC(new IntegerConverters()),
        SECTION_LIST(new StringConverters()),
        SECTION(new StringConverters()),
        STRING(new StringConverters());

        private final Converters converters;

        public static ConfigType getById(String id) {
            for (ConfigType c : ConfigType.values()) {
                if (!c.name().equalsIgnoreCase(id)) continue;
                return c;
            }
            return null;
        }

        private ConfigType(Converters converters) {
            this.converters = converters;
        }

        public Converters getConverters() {
            return this.converters;
        }
    }

    private static enum ConfigSource {
        DEFAULT_VALUE,
        DEFAULT_SECTION,
        SECTION;

    }

    private class ConfigValue {
        private final String value;
        private int lineNumber = -1;

        public ConfigValue(String value, int lineNumber) {
            this.value = value;
            this.lineNumber = lineNumber;
        }

        public String getValue() {
            return this.value;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public ConfigValue copy() {
            return new ConfigValue(this.value, this.lineNumber);
        }
    }

    private static class BooleanConverters
    implements Converters {
        private BooleanConverters() {
        }

        @Override
        public String objectToString(Object o) {
            return (Boolean)o != false ? "true" : "false";
        }

        @Override
        public Object stringToObject(String s) {
            return "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s);
        }
    }

    private static class IntegerConverters
    implements Converters {
        private IntegerConverters() {
        }

        @Override
        public String objectToString(Object o) {
            return String.valueOf(o);
        }

        @Override
        public Object stringToObject(String s) {
            return Integer.valueOf(s);
        }
    }

    private static class StringConverters
    implements Converters {
        private StringConverters() {
        }

        @Override
        public String objectToString(Object o) {
            return (String)o;
        }

        @Override
        public Object stringToObject(String s) {
            return s;
        }
    }

    static interface Converters {
        public String objectToString(Object var1) throws IllegalArgumentException;

        public Object stringToObject(String var1) throws IllegalArgumentException;
    }
}

