/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EvictionConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.NearCachePreloaderConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.NearCacheConfigHolder;
import com.hazelcast.config.NearCachePreloaderConfig;

public final class NearCacheConfigHolderCodec {
    private static final int SERIALIZE_KEYS_FIELD_OFFSET = 0;
    private static final int INVALIDATE_ON_CHANGE_FIELD_OFFSET = 1;
    private static final int TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 2;
    private static final int MAX_IDLE_SECONDS_FIELD_OFFSET = 6;
    private static final int CACHE_LOCAL_ENTRIES_FIELD_OFFSET = 10;
    private static final int INITIAL_FRAME_SIZE = 11;

    private NearCacheConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, NearCacheConfigHolder nearCacheConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[11]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, nearCacheConfigHolder.isSerializeKeys());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 1, nearCacheConfigHolder.isInvalidateOnChange());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 2, nearCacheConfigHolder.getTimeToLiveSeconds());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 6, nearCacheConfigHolder.getMaxIdleSeconds());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 10, nearCacheConfigHolder.isCacheLocalEntries());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, nearCacheConfigHolder.getName());
        StringCodec.encode(clientMessage, nearCacheConfigHolder.getInMemoryFormat());
        EvictionConfigHolderCodec.encode(clientMessage, nearCacheConfigHolder.getEvictionConfigHolder());
        StringCodec.encode(clientMessage, nearCacheConfigHolder.getLocalUpdatePolicy());
        CodecUtil.encodeNullable(clientMessage, nearCacheConfigHolder.getPreloaderConfig(), NearCachePreloaderConfigCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static NearCacheConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean serializeKeys = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        boolean invalidateOnChange = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 1);
        int timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 2);
        int maxIdleSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 6);
        boolean cacheLocalEntries = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 10);
        String name = StringCodec.decode(iterator);
        String inMemoryFormat = StringCodec.decode(iterator);
        EvictionConfigHolder evictionConfigHolder = EvictionConfigHolderCodec.decode(iterator);
        String localUpdatePolicy = StringCodec.decode(iterator);
        NearCachePreloaderConfig preloaderConfig = CodecUtil.decodeNullable(iterator, NearCachePreloaderConfigCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new NearCacheConfigHolder(name, inMemoryFormat, serializeKeys, invalidateOnChange, timeToLiveSeconds, maxIdleSeconds, evictionConfigHolder, cacheLocalEntries, localUpdatePolicy, preloaderConfig);
    }
}

