/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractTransform
implements Transform {
    @Nonnull
    private String name;
    @Nonnull
    private List<Transform> upstream;
    private int localParallelism = -1;
    private int determinedLocalParallelism = -1;
    private boolean[] upstreamRebalancingFlags;
    private FunctionEx<?, ?>[] upstreamPartitionKeyFns;

    public AbstractTransform() {
    }

    protected AbstractTransform(@Nonnull String name, @Nonnull List<Transform> upstream) {
        this.name = name;
        this.upstream = new ArrayList<Transform>(upstream);
        this.upstreamRebalancingFlags = new boolean[upstream.size()];
        this.upstreamPartitionKeyFns = new FunctionEx[upstream.size()];
    }

    protected AbstractTransform(String name, @Nonnull Transform upstream) {
        this(name, Collections.singletonList(upstream));
    }

    @Override
    @Nonnull
    public List<Transform> upstream() {
        return this.upstream;
    }

    void setUpstream(@Nonnull List<Transform> upstream) {
        this.upstream = upstream;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    @Nonnull
    public String name() {
        return this.name;
    }

    @Override
    public void localParallelism(int localParallelism) {
        this.localParallelism = Vertex.checkLocalParallelism(localParallelism);
    }

    @Override
    public int localParallelism() {
        return this.localParallelism;
    }

    @Override
    public void determinedLocalParallelism(int determinedLocalParallelism) {
        this.determinedLocalParallelism = Vertex.checkLocalParallelism(determinedLocalParallelism);
    }

    @Override
    public int determinedLocalParallelism() {
        return this.determinedLocalParallelism;
    }

    @Override
    public void setRebalanceInput(int ordinal, boolean value) {
        this.upstreamRebalancingFlags[ordinal] = value;
    }

    @Override
    public boolean shouldRebalanceInput(int ordinal) {
        return this.upstreamRebalancingFlags[ordinal];
    }

    protected boolean[] upstreamRebalancingFlags() {
        return this.upstreamRebalancingFlags;
    }

    @Override
    public void setPartitionKeyFnForInput(int ordinal, FunctionEx<?, ?> keyFn) {
        this.upstreamPartitionKeyFns[ordinal] = keyFn;
    }

    protected FunctionEx<?, ?>[] upstreamPartitionKeyFns() {
        return this.upstreamPartitionKeyFns;
    }

    @Override
    public FunctionEx<?, ?> partitionKeyFnForInput(int ordinal) {
        return this.upstreamPartitionKeyFns[ordinal];
    }

    public String toString() {
        return this.name;
    }

    @Override
    public long preferredWatermarkStride() {
        return 0L;
    }

    protected final boolean shouldRebalanceAnyInput() {
        for (boolean b : this.upstreamRebalancingFlags) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    protected void determineLocalParallelism(int preferredLocalParallelism, PipelineImpl.Context context, boolean shouldMatchUpstreamParallelism) {
        int defaultParallelism = context.defaultLocalParallelism();
        int upstreamParallelism = -1;
        if (shouldMatchUpstreamParallelism && !this.upstream().isEmpty()) {
            upstreamParallelism = this.upstream().stream().mapToInt(Transform::determinedLocalParallelism).min().getAsInt();
        }
        int currParallelism = this.localParallelism() == -1 ? (preferredLocalParallelism == -1 ? defaultParallelism : (defaultParallelism == -1 ? preferredLocalParallelism : Math.min(preferredLocalParallelism, defaultParallelism))) : this.localParallelism();
        if (upstreamParallelism != -1) {
            if (currParallelism != -1) {
                this.determinedLocalParallelism(Math.min(upstreamParallelism, currParallelism));
            } else {
                this.determinedLocalParallelism(upstreamParallelism);
            }
        } else {
            this.determinedLocalParallelism(currParallelism);
        }
    }
}

