/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Beta
public class RowValue
implements Serializable,
IdentifiedDataSerializable {
    private List<Object> values;

    public RowValue() {
        this.values = new ArrayList<Object>();
    }

    public RowValue(List<Object> values) {
        this.values = values;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.values.size());
        for (Object value : this.values) {
            out.writeObject(value);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.values = new ArrayList<Object>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.values.add(in.readObject());
        }
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 66;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowValue rowValue = (RowValue)o;
        return Objects.equals(this.values, rowValue.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return this.values.toString();
    }
}

