/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class AsymmetricAlgorithmSpec
extends AbstractBlock
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000003L;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    Algorithm algorithm;
    AlgorithmParameter parameter;

    public AsymmetricAlgorithmSpec(AsymmetricAlgorithmSpec to) throws IOException {
        this.parse(to.toAsn1Object(DumpType.ALL));
    }

    public AsymmetricAlgorithmSpec(Algorithm alg, AlgorithmParameter params) {
        this.algorithm = alg;
        this.parameter = params;
    }

    public AsymmetricAlgorithmSpec(ASN1Encodable to) throws IOException {
        this.parse(to);
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        int i2 = 0;
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        ASN1Enumerated en = ASN1Enumerated.getInstance(s1.getObjectAt(i2++));
        this.algorithm = Algorithm.getById(en.getValue().intValue());
        if (s1.size() > 1) {
            this.parameter = new AlgorithmParameter(s1.getObjectAt(i2++));
        }
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmParameter getAlgorithmParameter() {
        return this.parameter;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumptype) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        sb.append(prefix).append("  ").append("algorithm ").append(this.algorithm.name().toLowerCase());
        if (this.parameter != null) {
            sb.append(',').append("\r\n");
            sb.append(prefix).append("  ").append("parameter ").append(this.parameter.dumpValueNotation(prefix + "  ", dumptype)).append("\r\n");
        } else {
            sb.append("\r\n");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        if (this.algorithm == null) {
            throw new IOException("Algorithm is empty .. unable to create AsymmetricAlgorithmSpec");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Enumerated(this.algorithm.getId()));
        if (this.parameter != null) {
            v.add(this.parameter.toAsn1Object(dumpType));
        }
        return new DERSequence(v);
    }
}

