/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Security;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.RandomString;
import net.messagevortex.transport.SaslMechanisms;
import net.messagevortex.transport.SaslPlainServer;
import net.messagevortex.transport.SaslServerCallbackHandler;
import net.messagevortex.transport.imap.ImapCommand;
import net.messagevortex.transport.imap.ImapCommandFactory;
import net.messagevortex.transport.imap.ImapConnection;
import net.messagevortex.transport.imap.ImapConnectionState;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapLine;
import org.bouncycastle.util.encoders.Base64;

public class ImapCommandAuthenticate
extends ImapCommand {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    public void init() {
        ImapCommandFactory.registerCommand(this);
    }

    public static String getChallenge(int length) {
        return RandomString.nextString(length);
    }

    @Override
    public String[] processCommand(ImapLine line) throws ImapException {
        Security.addProvider(new SaslPlainServer.SecurityProvider());
        String mech = line.getATag();
        LOGGER.log(Level.INFO, "authenticate has read mec " + mech);
        line.skipWhitespace(-1);
        String context = line.getATag();
        LOGGER.log(Level.INFO, "authenticate has read context information (PLAIN only) \"" + context + "\"");
        if (!line.skipLineEnd()) {
            throw new ImapException(line, "error parsing command");
        }
        LOGGER.log(Level.INFO, "has parsed last character of line");
        if (line.getConnection() == null) {
            LOGGER.log(Level.SEVERE, "no connection found while calling login");
            return new String[]{line.getTag() + " BAD server configuration error\r\n"};
        }
        if (line.getConnection().getAuth() == null) {
            LOGGER.log(Level.SEVERE, "no Authenticator or connection found while calling login (2)");
            return new String[]{line.getTag() + " BAD server configuration error\r\n"};
        }
        SaslServerCallbackHandler serverHandler = new SaslServerCallbackHandler(line.getConnection().getAuth());
        SaslServer ss = null;
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            if (!line.getConnection().isTls()) {
                props.put("javax.security.sasl.policy.noplaintext", "true");
            }
            String serverName = "theRealm";
            ss = Sasl.createSaslServer(mech, "IMAP", serverName, props, serverHandler);
        }
        catch (SaslException e) {
            LOGGER.log(Level.WARNING, "unsuported sasl mech " + mech + " requested by client (2)", e);
            return new String[]{line.getTag() + " BAD server configuration error\r\n"};
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "got unexpected exception", e);
            throw e;
        }
        if (ss == null) {
            LOGGER.log(Level.WARNING, "unsuported sasl mech " + mech + " requested by client (1)");
            return new String[]{line.getTag() + " BAD server configuration error\r\n"};
        }
        LOGGER.log(Level.INFO, "preparing challenge");
        byte[] saslChallenge = null;
        byte[] saslReply = null;
        try {
            if (context != null && SaslMechanisms.PLAIN.toString().equals(mech)) {
                saslReply = Base64.decode(context);
            } else {
                saslChallenge = ss.evaluateResponse(new byte[0]);
                LOGGER.log(Level.INFO, "sending challenge");
                if (saslChallenge.length > 0) {
                    LOGGER.log(Level.INFO, "sending challenge (" + saslChallenge.length + " bytes; " + new String(Base64.encode(saslChallenge), StandardCharsets.UTF_8) + ")");
                    line.getConnection().writeln("+ " + new String(Base64.encode(saslChallenge), StandardCharsets.UTF_8));
                } else {
                    LOGGER.log(Level.INFO, "sending empty challenge");
                    line.getConnection().writeln("+ ");
                }
                LOGGER.log(Level.INFO, "getting reply");
                try {
                    String reply = line.getConnection().readln(300000L);
                    LOGGER.log(Level.INFO, "got reply (" + reply + ")");
                    saslReply = Base64.decode(reply);
                }
                catch (TimeoutException te) {
                    throw new IOException("Tmeout while wating for sasl challenge reply", te);
                }
            }
            LOGGER.log(Level.INFO, "evaluating reply");
            ss.evaluateResponse(saslReply);
            LOGGER.log(Level.INFO, "reply evaluated");
            if (ss.isComplete()) {
                LOGGER.log(Level.INFO, "Sucessfully authenticated");
                line.getConnection().setImapState(ImapConnectionState.CONNECTION_AUTHENTICATED);
                return new String[]{line.getTag() + " OK LOGIN completed\r\n"};
            }
            LOGGER.log(Level.INFO, "Bad username or password");
            return new String[]{line.getTag() + " BAD login failed\r\n"};
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "failed processing sasl reply");
            return new String[]{line.getTag() + " BAD login failed\r\n"};
        }
    }

    @Override
    public String[] getCommandIdentifier() {
        return new String[]{"AUTHENTICATE"};
    }

    private String getAuthToken(ImapLine line) throws ImapException {
        String userid = line.getAString();
        if (userid == null) {
            throw new ImapException(line, "error parsing command (getting userid)");
        }
        return userid;
    }

    @Override
    public String[] getCapabilities(ImapConnection ic) {
        if (ic == null || ic.getImapState() == ImapConnectionState.CONNECTION_NOT_AUTHENTICATED) {
            if (ic != null && ic.isTls()) {
                return new String[]{"AUTH=CRAM-MD5", "AUTH=PLAIN"};
            }
            return new String[]{"AUTH=CRAM-MD5"};
        }
        return new String[0];
    }
}

