/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractMavenReport
extends AbstractMojo
implements MavenMultiPageReport {
    @Parameter(defaultValue="${project.build.directory}/reports", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}", readonly=true)
    private String inputEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}", readonly=true)
    private String outputEncoding;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> remoteProjectRepositories;
    @Parameter(defaultValue="${basedir}/src/site")
    protected File siteDirectory;
    @Parameter(defaultValue="default")
    protected String locale;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Component
    protected SiteTool siteTool;
    @Component
    protected Renderer siteRenderer;
    private Sink sink;
    private SinkFactory sinkFactory;
    private File reportOutputDirectory;
    @Parameter(property="output.format")
    protected String outputFormat;
    @Component
    private PlexusContainer container;

    public final void execute() throws MojoExecutionException {
        try {
            if (!this.canGenerateReport()) {
                String reportMojoInfo = this.mojoExecution.getPlugin().getId() + ":" + this.mojoExecution.getGoal();
                this.getLog().info((CharSequence)("Skipping " + reportMojoInfo + " report goal"));
                return;
            }
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Failed to determine whether report can be generated", (Exception)e);
        }
        if (this.outputFormat != null) {
            this.reportToMarkup();
        } else {
            this.reportToSite();
        }
    }

    private void reportToMarkup() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Rendering to " + this.outputFormat + " markup"));
        if (!this.isExternalReport()) {
            File outputDirectory = new File(this.getOutputDirectory());
            String filename = this.getOutputName() + '.' + this.outputFormat;
            try {
                this.sinkFactory = this.container.lookup(SinkFactory.class, this.outputFormat);
                this.sink = this.sinkFactory.createSink(outputDirectory, filename);
            }
            catch (ComponentLookupException cle) {
                throw new MojoExecutionException("Cannot find SinkFactory for Doxia output format: " + this.outputFormat, (Exception)cle);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Cannot create sink to " + new File(outputDirectory, filename), (Exception)ioe);
            }
        }
        try {
            Locale locale = this.getLocale();
            this.generate(this.sink, this.sinkFactory, locale);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
        finally {
            if (this.sink != null) {
                this.sink.close();
            }
        }
    }

    private void reportToSite() throws MojoExecutionException {
        File outputDirectory = new File(this.getOutputDirectory());
        String filename = this.getOutputName() + ".html";
        Locale locale = this.getLocale();
        try {
            SiteRenderingContext siteContext = this.createSiteRenderingContext(locale);
            this.getSiteRenderer().copyResources(siteContext, outputDirectory);
            String reportMojoInfo = this.mojoExecution.getPlugin().getId() + ":" + this.mojoExecution.getGoal();
            DocumentRenderingContext docRenderingContext = new DocumentRenderingContext(outputDirectory, this.getOutputName(), reportMojoInfo);
            SiteRendererSink sink = new SiteRendererSink(docRenderingContext);
            this.generate(sink, null, locale);
            if (!this.isExternalReport()) {
                outputDirectory.mkdirs();
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDirectory, filename)), this.getOutputEncoding());){
                    this.getSiteRenderer().mergeDocumentIntoSite(writer, sink, siteContext);
                }
            }
            this.getSiteRenderer().copyResources(siteContext, outputDirectory);
        }
        catch (IOException | RendererException | SiteToolException | MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", e);
        }
    }

    private SiteRenderingContext createSiteRenderingContext(Locale locale) throws MavenReportException, IOException, SiteToolException {
        SiteRenderingContext context;
        SiteModel siteModel = this.siteTool.getSiteModel(this.siteDirectory, locale, this.project, this.reactorProjects, this.repoSession, this.remoteProjectRepositories);
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        templateProperties.put("standalone", Boolean.TRUE);
        templateProperties.put("project", this.getProject());
        templateProperties.put("inputEncoding", this.getInputEncoding());
        templateProperties.put("outputEncoding", this.getOutputEncoding());
        for (Map.Entry<Object, Object> entry : this.getProject().getProperties().entrySet()) {
            templateProperties.put((String)entry.getKey(), entry.getValue());
        }
        try {
            Artifact skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.repoSession, this.remoteProjectRepositories, siteModel.getSkin());
            this.getLog().info((CharSequence)MessageUtils.buffer().a("Rendering content with ").strong(skinArtifact.getId() + " skin").toString());
            context = this.siteRenderer.createContextForSkin(skinArtifact, templateProperties, siteModel, this.project.getName(), locale);
        }
        catch (SiteToolException e) {
            throw new MavenReportException("Failed to retrieve skin artifact", e);
        }
        catch (RendererException e) {
            throw new MavenReportException("Failed to create context for skin", e);
        }
        MavenArchiver.parseBuildOutputTimestamp(this.outputTimestamp).ifPresent(v -> context.setPublishDate(Date.from(v)));
        context.setRootDirectory(this.project.getBasedir());
        return context;
    }

    @Override
    @Deprecated
    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate(sink, null, locale);
    }

    @Override
    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        this.sink = sink;
        this.sinkFactory = sinkFactory;
        this.executeReport(locale);
        this.closeReport();
    }

    @Override
    public String getCategoryName() {
        return "Project Reports";
    }

    @Override
    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    @Override
    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
        this.outputDirectory = reportOutputDirectory;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getInputEncoding() {
        return this.inputEncoding == null ? ReaderFactory.FILE_ENCODING : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected Locale getLocale() {
        return this.siteTool.getSiteLocales(this.locale).get(0);
    }

    protected void closeReport() {
        if (this.getSink() != null) {
            this.getSink().close();
        }
    }

    public Sink getSink() {
        return this.sink;
    }

    public SinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    @Override
    public boolean isExternalReport() {
        return false;
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        return true;
    }

    protected abstract void executeReport(Locale var1) throws MavenReportException;

    protected File getXrefLocation(File location, boolean test) {
        return location != null ? location : new File(this.getReportOutputDirectory(), test ? "xref-test" : "xref");
    }

    protected String constructXrefLocation(File location, boolean test) {
        String constructedLocation = null;
        File xrefLocation = this.getXrefLocation(location, test);
        String relativePath = PathTool.getRelativePath(this.getReportOutputDirectory().getAbsolutePath(), xrefLocation.getAbsolutePath());
        if (relativePath == null || relativePath.isEmpty()) {
            relativePath = ".";
        }
        relativePath = relativePath + "/" + xrefLocation.getName();
        if (xrefLocation.exists()) {
            constructedLocation = relativePath;
        } else {
            Reporting reporting = this.project.getModel().getReporting();
            List<Object> reportPlugins = reporting != null ? reporting.getPlugins() : Collections.emptyList();
            for (ReportPlugin reportPlugin : reportPlugins) {
                String artifactId = reportPlugin.getArtifactId();
                if (!"maven-jxr-plugin".equals(artifactId)) continue;
                constructedLocation = relativePath;
            }
        }
        if (constructedLocation == null) {
            this.getLog().warn((CharSequence)("Unable to locate" + (test ? " Test" : "") + " Source XRef to link to -- DISABLED"));
        }
        return constructedLocation;
    }
}

