/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.codehaus.plexus.util.cli.Commandline;

public class HgConfig {
    private static final String HG_REQ = "0.9.2";
    private static final String HG_VERSION_TAG = "Mercurial Distributed SCM (version ";
    private static final String HG_INSTALL_URL = "'http://www.selenic.com/mercurial/wiki/index.cgi/Download'";
    private HgVersionConsumer hgVersion = new HgVersionConsumer(null);

    HgConfig(File workingDir) {
        try {
            this.hgVersion = HgConfig.getHgVersion(workingDir);
        }
        catch (ScmException scmException) {
            // empty catch block
        }
    }

    private boolean isInstalled() {
        return this.hgVersion.isVersionOk(HG_REQ);
    }

    private boolean isComplete() {
        return this.isInstalled();
    }

    public static HgVersionConsumer getHgVersion(File workingDir) throws ScmException {
        String[] versionCmd = new String[]{"version"};
        HgVersionConsumer consumer = new HgVersionConsumer(HG_VERSION_TAG);
        Commandline cmd = HgUtils.buildCmd(workingDir, versionCmd);
        HgUtils.executeCmd(consumer, cmd);
        return consumer;
    }

    private static boolean compareVersion(String version1, String version2) {
        int x;
        int l2;
        String v1 = version1;
        String v2 = version2;
        int l1 = version1.length();
        if (l1 > (l2 = version2.length())) {
            for (x = l2; x >= l1; --x) {
                v2 = v2 + ' ';
            }
        }
        if (l2 > l1) {
            for (x = l1; x <= l2; ++x) {
                v1 = v1 + ' ';
            }
        }
        return v2.compareTo(v1) >= 0;
    }

    private String getInstalledStr() {
        if (this.isComplete()) {
            return "valid and complete.";
        }
        return (this.isInstalled() ? "incomplete. " : "invalid. ") + "Consult " + HG_INSTALL_URL;
    }

    public String toString(File workingDir) {
        boolean hgOk = this.hgVersion.isVersionOk(HG_REQ);
        return "\n  Your Hg installation seems to be " + this.getInstalledStr() + "\n    Hg version: " + this.hgVersion.getVersion() + (hgOk ? " (OK)" : " (May be INVALID)") + "\n";
    }

    private static class HgVersionConsumer
    extends HgConsumer {
        private String versionStr = "NA";
        private String versionTag;

        HgVersionConsumer(String versionTag) {
            this.versionTag = versionTag;
        }

        @Override
        public void doConsume(ScmFileStatus status, String line) {
            if (line.startsWith(this.versionTag)) {
                String[] elements = line.split(" ");
                this.versionStr = elements[elements.length - 1].split("\\)")[0];
            }
        }

        String getVersion() {
            return this.versionStr;
        }

        boolean isVersionOk(String version) {
            return HgConfig.compareVersion(version, this.versionStr);
        }
    }
}

