/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.util.AbstractConsumer;

public abstract class AbstractFileCheckingConsumer
extends AbstractConsumer {
    protected File workingDirectory;
    private final List<ScmFile> files = new ArrayList<ScmFile>();
    protected int revision;
    private boolean filtered;

    public AbstractFileCheckingConsumer(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public final void consumeLine(String line) {
        if (line.length() <= 3) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        try {
            this.parseLine(line);
        }
        catch (RuntimeException re) {
            this.logger.warn("RuntimeException while parsing: " + line, re);
            throw re;
        }
    }

    protected abstract void parseLine(String var1);

    protected List<ScmFile> getFiles() {
        if (!this.filtered) {
            Iterator<ScmFile> ite = this.files.iterator();
            while (ite.hasNext()) {
                ScmFile file = ite.next();
                if (file.getStatus().equals(ScmFileStatus.DELETED) || new File(this.workingDirectory, file.getPath()).isFile()) continue;
                ite.remove();
            }
            this.filtered = true;
        }
        return this.files;
    }

    protected final int parseInt(String revisionString) {
        try {
            return Integer.parseInt(revisionString);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    protected void addFile(ScmFile file) {
        this.files.add(file);
    }

    public final int getRevision() {
        return this.revision;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

