/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.internal.DirectScopeDependencySelector;
import org.apache.maven.shared.dependency.graph.internal.VerboseJavaScopeSelector;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;

public class DependencyCollectorRequest {
    private final ProjectBuildingRequest buildingRequest;
    private ArtifactFilter filter;
    private Map<String, Object> configProperties = new HashMap<String, Object>();
    private DependencySelector dependencySelector = new AndDependencySelector(new DirectScopeDependencySelector("test"), new DirectScopeDependencySelector("provided"), new OptionalDependencySelector(), new ExclusionDependencySelector());
    private DependencyGraphTransformer dependencyGraphTransformer = new ConflictResolver(new NearestVersionSelector(), new VerboseJavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());

    public DependencyCollectorRequest(ProjectBuildingRequest buildingRequest) {
        this(buildingRequest, null);
    }

    public DependencyCollectorRequest(ProjectBuildingRequest buildingRequest, ArtifactFilter filter) {
        Objects.requireNonNull(buildingRequest, "ProjectBuildingRequest cannot be null");
        this.buildingRequest = buildingRequest;
        this.filter = filter;
        this.configProperties.put("aether.conflictResolver.verbose", true);
        this.configProperties.put("aether.dependencyManager.verbose", true);
    }

    public ProjectBuildingRequest getBuildingRequest() {
        return this.buildingRequest;
    }

    public ArtifactFilter getFilter() {
        return this.filter;
    }

    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public DependencyCollectorRequest dependencySelector(DependencySelector dependencySelector) {
        this.dependencySelector = dependencySelector;
        return this;
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public DependencyCollectorRequest dependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        return this;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public void addConfigProperty(String key, Object value) {
        this.configProperties.put(key, value);
    }

    public void removeConfigProperty(String key) {
        this.configProperties.remove(key);
    }
}

