/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1.encryption;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import net.messagevortex.asn1.encryption.EllipticCurveType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;

public enum Parameter implements Serializable
{
    ALGORITHM(1, "algorithm", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return new String(ASN1OctetString.getInstance((Object)o).getOctets(), StandardCharsets.UTF_8);
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new DEROctetString(s.getBytes(StandardCharsets.UTF_8));
        }
    }),
    KEYSIZE(10000, "keySize", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return ASN1Integer.getInstance((Object)o).getPositiveValue().toString();
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new ASN1Integer((long)Integer.parseInt(s));
        }
    }),
    CURVETYPE(10001, "curveType", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return EllipticCurveType.getById(ASN1Enumerated.getInstance((Object)o).getValue().intValue()).toString();
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new ASN1Enumerated(EllipticCurveType.getByString(s).getId());
        }
    }),
    IV(10002, "initialisationVector", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return new String(ASN1OctetString.getInstance((Object)o).getOctets(), StandardCharsets.UTF_8);
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new DEROctetString(s.getBytes(StandardCharsets.UTF_8));
        }
    }),
    NONCE(10003, "nonce", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return new String(ASN1OctetString.getInstance((Object)o).getOctets(), StandardCharsets.UTF_8);
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new DEROctetString(s.getBytes(StandardCharsets.UTF_8));
        }
    }),
    MODE(10004, "mode", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return new String(ASN1OctetString.getInstance((Object)o).getOctets(), StandardCharsets.UTF_8);
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new DEROctetString(s.getBytes(StandardCharsets.UTF_8));
        }
    }),
    PADDING(10005, "padding", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return new String(ASN1OctetString.getInstance((Object)o).getOctets(), StandardCharsets.UTF_8);
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new DEROctetString(s.getBytes(StandardCharsets.UTF_8));
        }
    }),
    BLOCKSIZE(10100, "blockSize", new Transcoder(){

        @Override
        public String fromAsn1(ASN1Object o) {
            return ASN1Integer.getInstance((Object)o).getPositiveValue().toString();
        }

        @Override
        public ASN1Encodable toAsn1(String s) {
            return new ASN1Integer((long)Integer.parseInt(s));
        }
    });

    final int id;
    final String txt;
    final Transcoder transcoder;

    private Parameter(int id, String txt, Transcoder transcoder) {
        this.id = id;
        this.txt = txt;
        this.transcoder = transcoder;
    }

    public static Parameter getById(int id) {
        for (Parameter e : Parameter.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public static Parameter getByString(String s) {
        for (Parameter e : Parameter.values()) {
            if (!e.toString().equals(s)) continue;
            return e;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public boolean isEncodable() {
        return this.transcoder != null;
    }

    public String fromAsn1Object(ASN1Object o) {
        return this.transcoder.fromAsn1(o);
    }

    public ASN1Encodable toAsn1Object(String s) {
        return this.transcoder.toAsn1(s);
    }

    public String toString() {
        return this.txt;
    }

    private static interface Transcoder {
        public String fromAsn1(ASN1Object var1);

        public ASN1Encodable toAsn1(String var1);
    }
}

