/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.encryption.DumpType;
import picocli.CommandLine;

@CommandLine.Command(description={"add an identity and dump store"}, name="addIdentity", aliases={"add"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerIdentityStoreAdd
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--filename", "-f"}, description={"filename of the IdentityStorage file"})
    String filename = "identityStore.cfg";
    @CommandLine.Option(names={"--identity"}, required=true, description={"the identity URL"})
    String[] identity;

    @Override
    public Integer call() throws Exception {
        if (!new File(this.filename).exists()) {
            LOGGER.log(Level.SEVERE, "File \"" + this.filename + "\" not found");
            return 103;
        }
        LOGGER.log(Level.INFO, "Loading identity store \"" + this.filename + "\"");
        IdentityStore is = new IdentityStore(new File(this.filename));
        for (String id : this.identity) {
            LOGGER.log(Level.INFO, "Adding new identity for \"" + id + "\"");
            IdentityStoreBlock isb = new IdentityStoreBlock(id);
            is.add(isb);
        }
        LOGGER.log(Level.INFO, "Dumping identity store");
        System.out.println(is.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
        LOGGER.log(Level.INFO, "writing identity store to \"" + this.filename + "\"");
        try (OutputStream os = Files.newOutputStream(Paths.get(this.filename, new String[0]), new OpenOption[0]);){
            os.write(is.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        LOGGER.log(Level.INFO, "finished");
        return 0;
    }
}

