/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.internal;

import com.vladsch.flexmark.parser.PostProcessor;
import com.vladsch.flexmark.parser.PostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.ClassifyingNodeTracker;
import com.vladsch.flexmark.util.collection.NodeClassifierVisitor;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.dependency.DependencyHandler;
import com.vladsch.flexmark.util.dependency.DependentItem;
import com.vladsch.flexmark.util.dependency.DependentItemMap;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PostProcessorManager {
    private static final HashMap<DataKey<Boolean>, PostProcessorFactory> CORE_POST_PROCESSORS = new HashMap();
    private final PostProcessorDependencies postProcessorDependencies;
    private OrderedSet<Node> allPostProcessNodes = new OrderedSet();

    public PostProcessorManager(PostProcessorDependencies postProcessorDependencies) {
        this.postProcessorDependencies = postProcessorDependencies;
    }

    public static PostProcessorDependencies calculatePostProcessors(DataHolder options, List<PostProcessorFactory> postProcessorFactories) {
        ArrayList<PostProcessorFactory> list = new ArrayList<PostProcessorFactory>(postProcessorFactories);
        for (DataKey<Boolean> processorDataKey : CORE_POST_PROCESSORS.keySet()) {
            if (!((Boolean)processorDataKey.getFrom(options)).booleanValue()) continue;
            PostProcessorFactory preProcessorFactory = CORE_POST_PROCESSORS.get(processorDataKey);
            list.add(preProcessorFactory);
        }
        PostProcessDependencyHandler resolver = new PostProcessDependencyHandler();
        return (PostProcessorDependencies)resolver.resolveDependencies(list);
    }

    public static Document processDocument(Document document, PostProcessorDependencies processorDependencies) {
        if (!processorDependencies.isEmpty()) {
            PostProcessorManager manager = new PostProcessorManager(processorDependencies);
            document = manager.postProcess(document);
        }
        return document;
    }

    public Document postProcess(Document document) {
        ClassifyingNodeTracker classifyingNodeTracker = null;
        for (PostProcessorDependencyStage stage : this.postProcessorDependencies.getDependentStages()) {
            boolean hadGlobal = false;
            for (PostProcessorFactory dependent : stage.dependents) {
                if (dependent.affectsGlobalScope()) {
                    document = dependent.create(document).processDocument(document);
                    hadGlobal = true;
                    classifyingNodeTracker = null;
                    continue;
                }
                if (hadGlobal) {
                    boolean bl = false;
                }
                assert (!hadGlobal);
                if (classifyingNodeTracker == null) {
                    classifyingNodeTracker = new NodeClassifierVisitor(stage.myNodeMap).classify((Node)document);
                }
                Map<Class<?>, Set<Class<?>>> dependentNodeTypes = dependent.getNodeTypes();
                PostProcessor postProcessor = dependent.create(document);
                BitSet exclusionSet = new BitSet();
                for (Set<Class<?>> excluded : dependentNodeTypes.values()) {
                    BitSet mapped = classifyingNodeTracker.getExclusionSet().indexBitSet(excluded);
                    exclusionSet.or(mapped);
                }
                ReversibleIterable nodes = classifyingNodeTracker.getCategoryItems(Node.class, dependentNodeTypes.keySet());
                for (Node node : nodes) {
                    BitSet nodeAncestors;
                    int index;
                    if (node.getParent() == null) continue;
                    Set<Class<?>> excluded = dependentNodeTypes.get(node.getClass());
                    if (excluded != null && (index = classifyingNodeTracker.getItems().indexOf((Object)node)) != -1 && (nodeAncestors = (BitSet)classifyingNodeTracker.getNodeAncestryMap().get(index)) != null) {
                        BitSet nodeExclusions = classifyingNodeTracker.getExclusionSet().indexBitSet(excluded);
                        nodeExclusions.and(nodeAncestors);
                        if (!nodeExclusions.isEmpty()) continue;
                    }
                    postProcessor.process((NodeTracker)classifyingNodeTracker, node);
                }
            }
        }
        return document;
    }

    private static class PostProcessDependencyHandler
    extends DependencyHandler<PostProcessorFactory, PostProcessorDependencyStage, PostProcessorDependencies> {
        private PostProcessDependencyHandler() {
        }

        protected Class<? extends PostProcessorFactory> getDependentClass(PostProcessorFactory dependent) {
            return dependent.getClass();
        }

        protected PostProcessorDependencies createResolvedDependencies(List<PostProcessorDependencyStage> stages) {
            return new PostProcessorDependencies(stages);
        }

        protected PostProcessorDependencyStage createStage(List<PostProcessorFactory> dependents) {
            return new PostProcessorDependencyStage(dependents);
        }

        protected DependentItemMap<PostProcessorFactory> prioritize(DependentItemMap<PostProcessorFactory> dependentMap) {
            List prioritized = dependentMap.entries();
            Collections.sort(prioritized, new Comparator<Map.Entry<Class, DependentItem<PostProcessorFactory>>>(){

                @Override
                public int compare(Map.Entry<Class, DependentItem<PostProcessorFactory>> e1, Map.Entry<Class, DependentItem<PostProcessorFactory>> e2) {
                    int g1 = e1.getValue().isGlobalScope ? 1 : 0;
                    int g2 = e2.getValue().isGlobalScope ? 1 : 0;
                    return g1 - g2;
                }
            });
            BitSet dependentMapSet = dependentMap.keySet().keyDifferenceBitSet((Iterable)prioritized);
            if (dependentMapSet.isEmpty()) {
                return dependentMap;
            }
            DependentItemMap prioritizedMap = new DependentItemMap(prioritized.size());
            prioritizedMap.addAll((Collection)prioritized);
            return prioritizedMap;
        }
    }

    public static class PostProcessorDependencies
    extends ResolvedDependencies<PostProcessorDependencyStage> {
        private final boolean myWithExclusions;

        public PostProcessorDependencies(List<PostProcessorDependencyStage> dependentStages) {
            super(dependentStages);
            boolean haveExclusions = false;
            for (PostProcessorDependencyStage stage : dependentStages) {
                if (!stage.myWithExclusions) continue;
                haveExclusions = true;
                break;
            }
            this.myWithExclusions = haveExclusions;
        }

        public boolean isWithExclusions() {
            return this.myWithExclusions;
        }
    }

    public static class PostProcessorDependencyStage {
        private final Map<Class<? extends Node>, Set<Class<?>>> myNodeMap;
        private final boolean myWithExclusions;
        private final List<PostProcessorFactory> dependents;

        public PostProcessorDependencyStage(List<PostProcessorFactory> dependents) {
            HashMap nodeMap = new HashMap();
            boolean[] haveExclusions = new boolean[]{false};
            for (PostProcessorFactory dependent : dependents) {
                Map<Class<?>, Set<Class<?>>> types = dependent.getNodeTypes();
                if ((types == null || types.isEmpty()) && !dependent.affectsGlobalScope()) {
                    throw new IllegalStateException("PostProcessorFactory " + dependent + " is not document post processor and has empty node map, does nothing, should not be registered.");
                }
                if (types == null) continue;
                for (Map.Entry<Class<?>, Set<Class<?>>> entry : types.entrySet()) {
                    if (!Node.class.isAssignableFrom(entry.getKey())) continue;
                    Set<Class<?>> classes = nodeMap.get(entry.getKey());
                    Set<Class<?>> value = entry.getValue();
                    if (classes == null) {
                        classes = value;
                        nodeMap.put(entry.getKey(), classes);
                    } else {
                        try {
                            classes.addAll(value);
                        }
                        catch (UnsupportedOperationException e) {
                            classes = new HashSet(classes);
                            classes.addAll(value);
                        }
                    }
                    if (classes.isEmpty()) continue;
                    haveExclusions[0] = true;
                }
            }
            this.dependents = dependents;
            this.myNodeMap = nodeMap;
            this.myWithExclusions = haveExclusions[0];
        }
    }
}

