/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes;

import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.util.ast.CustomNode;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.ReferencingNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class Footnote
extends CustomNode
implements DelimitedNode,
DoNotDecorate,
ReferencingNode<FootnoteRepository, FootnoteBlock> {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected FootnoteBlock footnoteBlock;
    protected int referenceOrdinal;

    public int getReferenceOrdinal() {
        return this.referenceOrdinal;
    }

    public void setReferenceOrdinal(int referenceOrdinal) {
        this.referenceOrdinal = referenceOrdinal;
    }

    public BasedSequence getReference() {
        return this.text;
    }

    public FootnoteBlock getReferenceNode(Document document) {
        if (this.footnoteBlock != null || this.text.isEmpty()) {
            return this.footnoteBlock;
        }
        this.footnoteBlock = this.getFootnoteBlock((FootnoteRepository)((Object)document.get(FootnoteExtension.FOOTNOTES)));
        return this.footnoteBlock;
    }

    public FootnoteBlock getReferenceNode(FootnoteRepository repository) {
        if (this.footnoteBlock != null || this.text.isEmpty()) {
            return this.footnoteBlock;
        }
        this.footnoteBlock = this.getFootnoteBlock(repository);
        return this.footnoteBlock;
    }

    public boolean isDefined() {
        return this.footnoteBlock != null;
    }

    public FootnoteBlock getFootnoteBlock(FootnoteRepository footnoteRepository) {
        return this.text.isEmpty() ? null : (FootnoteBlock)((Object)footnoteRepository.get(this.text.toString()));
    }

    public FootnoteBlock getFootnoteBlock() {
        return this.footnoteBlock;
    }

    public void setFootnoteBlock(FootnoteBlock footnoteBlock) {
        this.footnoteBlock = footnoteBlock;
    }

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    public void getAstExtra(StringBuilder out) {
        out.append(" ordinal: ").append(this.footnoteBlock != null ? this.footnoteBlock.getFootnoteOrdinal() : 0).append(" ");
        Footnote.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (BasedSequence)this.text, (BasedSequence)this.closingMarker, (String)"text");
    }

    public Footnote() {
    }

    public Footnote(BasedSequence chars) {
        super(chars);
    }

    public Footnote(BasedSequence openingMarker, BasedSequence text, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.text = text;
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

