/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingTemplateEngine.class);
    private final TemplateEngines renderers;

    @Deprecated
    public DelegatingTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
        this.renderers = new TemplateEngines(this.config, db);
    }

    public DelegatingTemplateEngine(ContentStore db, JBakeConfiguration config) {
        super(config, db);
        this.renderers = new TemplateEngines(config, db);
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        String ext;
        AbstractTemplateEngine engine;
        model.put("version", this.config.getVersion());
        HashMap<String, Object> configModel = new HashMap<String, Object>();
        Iterator<String> configKeys = this.config.getKeys();
        while (configKeys.hasNext()) {
            String key = configKeys.next();
            Object valueObject = key.equals("index.paginate") ? Boolean.valueOf(this.config.getPaginateIndex()) : this.config.get(key);
            configModel.put(key.replace(".", "_"), valueObject);
        }
        model.put("config", configModel);
        File templateFolder = this.config.getTemplateFolder();
        File templateFile = new File(templateFolder, templateName);
        if (!templateFile.exists()) {
            LOGGER.info("Default template: {} was not found, searching for others...", (Object)templateName);
            String templateNameWithoutExt = templateName.substring(0, templateName.length() - 4);
            for (String extension : this.renderers.getRecognizedExtensions()) {
                templateFile = new File(templateFolder, templateNameWithoutExt + "." + extension);
                if (!templateFile.exists()) continue;
                LOGGER.info("Found alternative template file: {} using this instead", (Object)templateFile.getName());
                templateName = templateFile.getName();
                break;
            }
        }
        if ((engine = this.renderers.getEngine(ext = FileUtil.fileExt(templateName))) != null) {
            engine.renderDocument(model, templateName, writer);
        } else {
            LOGGER.error("Warning - No template engine found for template: {}", (Object)templateName);
        }
    }
}

