/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.File;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.LocaleUtils;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.LazyContextVariable;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateEngine
extends AbstractTemplateEngine {
    private static final String DEFAULT_TEMPLATE_MODE = "HTML";
    private final ReentrantLock lock = new ReentrantLock();
    private TemplateEngine templateEngine;
    private Context context = new Context();
    private FileTemplateResolver templateResolver;

    @Deprecated
    public ThymeleafTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
        this.initializeTemplateEngine();
    }

    public ThymeleafTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        this.initializeTemplateEngine();
    }

    private void initializeTemplateEngine() {
        this.templateResolver = new FileTemplateResolver();
        this.templateResolver.setPrefix(this.config.getTemplateFolder().getAbsolutePath() + File.separatorChar);
        this.templateResolver.setCharacterEncoding(this.config.getTemplateEncoding());
        this.templateResolver.setTemplateMode(DEFAULT_TEMPLATE_MODE);
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        this.templateEngine.clearTemplateCache();
    }

    private void updateTemplateMode(Map<String, Object> model) {
        this.templateResolver.setTemplateMode(this.getTemplateModeByModel(model));
    }

    private String getTemplateModeByModel(Map<String, Object> model) {
        String key;
        String configMode;
        Map config = (Map)model.get("config");
        Map content = (Map)model.get("content");
        if (config != null && content != null && (configMode = (String)config.get(key = "template_" + content.get("type") + "_thymeleaf_mode")) != null) {
            return configMode;
        }
        return DEFAULT_TEMPLATE_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        String localeString = this.config.getThymeleafLocale();
        Locale locale = localeString != null ? LocaleUtils.toLocale((String)localeString) : Locale.getDefault();
        this.lock.lock();
        try {
            this.initializeContext(locale, model);
            this.updateTemplateMode(model);
            this.templateEngine.process(templateName, (IContext)this.context, writer);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initializeContext(Locale locale, Map<String, Object> model) {
        this.context.clearVariables();
        this.context.setLocale(locale);
        this.context.setVariables(model);
        for (String key : extractors.keySet()) {
            this.context.setVariable(key, (Object)new ContextVariable(this.db, key, model));
        }
    }

    private class ContextVariable
    extends LazyContextVariable {
        private ContentStore db;
        private String key;
        private Map<String, Object> model;

        public ContextVariable(ContentStore db, String key, Map<String, Object> model) {
            this.db = db;
            this.key = key;
            this.model = model;
        }

        protected Object loadValue() {
            try {
                return AbstractTemplateEngine.extractors.extractAndTransform(this.db, this.key, this.model, new TemplateEngineAdapter<LazyContextVariable>(){

                    @Override
                    public LazyContextVariable adapt(String key, final Object extractedValue) {
                        if (key.equals("alltags")) {
                            return new LazyContextVariable<Set<?>>(){

                                protected Set<?> loadValue() {
                                    return (Set)extractedValue;
                                }
                            };
                        }
                        if (key.equals("published_date")) {
                            return new LazyContextVariable<Date>(){

                                protected Date loadValue() {
                                    return (Date)extractedValue;
                                }
                            };
                        }
                        return new LazyContextVariable<Object>(){

                            protected Object loadValue() {
                                return extractedValue;
                            }
                        };
                    }
                }).getValue();
            }
            catch (NoModelExtractorException e) {
                return "";
            }
        }
    }
}

