/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.util.JavaNameMangler;

public class BacktraceData
implements Serializable {
    public static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private RubyStackTraceElement[] backtraceElements;
    private final StackTraceElement[] javaTrace;
    private final BacktraceElement[] rubyTrace;
    private final boolean fullTrace;
    private final boolean maskNative;
    private final boolean includeNonFiltered;
    public static final BacktraceData EMPTY = new BacktraceData(EMPTY_STACK_TRACE, BacktraceElement.EMPTY_ARRAY, false, false, false);

    public BacktraceData(StackTraceElement[] javaTrace, BacktraceElement[] rubyTrace, boolean fullTrace, boolean maskNative, boolean includeNonFiltered) {
        this.javaTrace = javaTrace;
        this.rubyTrace = rubyTrace;
        this.fullTrace = fullTrace;
        this.maskNative = maskNative;
        this.includeNonFiltered = includeNonFiltered;
    }

    public final RubyStackTraceElement[] getBacktrace(Ruby runtime) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.constructBacktrace(runtime.getBoundMethods());
        }
        return this.backtraceElements;
    }

    public RubyStackTraceElement[] getBacktraceWithoutRuby() {
        return this.constructBacktrace(Collections.EMPTY_MAP);
    }

    private RubyStackTraceElement[] constructBacktrace(Map<String, Map<String, String>> boundMethods) {
        ArrayList<RubyStackTraceElement> trace2 = new ArrayList<RubyStackTraceElement>(this.javaTrace.length);
        boolean dupFrame = false;
        String dupFrameName = null;
        int rubyFrameIndex = this.rubyTrace == null ? -1 : this.rubyTrace.length - 1;
        for (int i2 = 0; i2 < this.javaTrace.length; ++i2) {
            FrameType frameType;
            String decodedName;
            StackTraceElement element = this.javaTrace[i2];
            int line = element.getLineNumber();
            String className = element.getClassName();
            String methodName = element.getMethodName();
            String filename2 = element.getFileName();
            if (filename2 != null && !filename2.endsWith(".java") && (decodedName = JavaNameMangler.decodeMethodForBacktrace(methodName)) != null) {
                RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, decodedName, filename2, line, false);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    trace2.add(new RubyStackTraceElement(className, dupFrameName, filename2, line, false));
                }
                trace2.add(rubyElement);
                continue;
            }
            String rubyName = methodName;
            if (this.fullTrace || (rubyName = BacktraceData.getBoundMethodName(boundMethods, className, methodName)) != null) {
                filename2 = BacktraceData.packagedFilenameFromElement(filename2, className);
                if (this.maskNative) {
                    dupFrame = true;
                    dupFrameName = rubyName;
                    continue;
                }
                trace2.add(new RubyStackTraceElement(className, rubyName, filename2, line, false));
                if (!this.fullTrace) continue;
            }
            if (rubyFrameIndex >= 0 && (frameType = FrameType.getInterpreterFrame(className, methodName)) != null) {
                String newName;
                BacktraceElement rubyFrame = this.rubyTrace[rubyFrameIndex--];
                switch (frameType) {
                    case METHOD: {
                        newName = rubyFrame.method;
                        break;
                    }
                    case BLOCK: {
                        newName = "block in " + rubyFrame.method;
                        break;
                    }
                    case CLASS: {
                        newName = "<class:" + rubyFrame.method + '>';
                        break;
                    }
                    case MODULE: {
                        newName = "<module:" + rubyFrame.method + '>';
                        break;
                    }
                    case METACLASS: {
                        newName = "singleton class";
                        break;
                    }
                    case ROOT: {
                        newName = "<main>";
                        break;
                    }
                    case EVAL: {
                        newName = "<eval>";
                        break;
                    }
                    default: {
                        newName = rubyFrame.method;
                    }
                }
                RubyStackTraceElement rubyElement = new RubyStackTraceElement("RUBY", newName, rubyFrame.filename, rubyFrame.line + 1, false);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    trace2.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
                }
                trace2.add(rubyElement);
                continue;
            }
            if (!this.includeNonFiltered || BacktraceData.isFilteredClass(className)) continue;
            filename2 = BacktraceData.packagedFilenameFromElement(filename2, className);
            trace2.add(new RubyStackTraceElement(className, methodName, filename2, line, false));
        }
        return trace2.toArray(new RubyStackTraceElement[trace2.size()]);
    }

    public static String getBoundMethodName(Map<String, Map<String, String>> boundMethods, String className, String methodName) {
        Map<String, String> javaToRuby = boundMethods.get(className);
        return javaToRuby == null ? null : javaToRuby.get(methodName);
    }

    private static String packagedFilenameFromElement(String filename2, String className) {
        if (filename2 == null) {
            return className.replace('.', '/');
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return filename2;
        }
        String pkgPath = className.substring(0, lastDot + 1).replace('.', '/');
        if (filename2.indexOf(47) > -1 && filename2.startsWith(pkgPath)) {
            return filename2;
        }
        return pkgPath + filename2;
    }

    private static boolean isFilteredClass(String className) {
        if (className.startsWith("sun.reflect.")) {
            return true;
        }
        String org_jruby_ = "org.jruby.";
        if (className.startsWith("org.jruby.")) {
            String subPackage;
            int dot = className.indexOf(46, "org.jruby.".length());
            if (dot == -1) {
                return false;
            }
            switch (subPackage = className.substring("org.jruby.".length(), dot)) {
                case "anno": {
                    return true;
                }
                case "ast": {
                    return true;
                }
                case "exceptions": {
                    return true;
                }
                case "gen": {
                    return true;
                }
                case "ir": {
                    return true;
                }
                case "internal": {
                    return true;
                }
                case "java": {
                    return true;
                }
                case "parser": {
                    return true;
                }
                case "platform": {
                    return true;
                }
                case "runtime": {
                    return true;
                }
                case "util": {
                    return true;
                }
            }
        }
        return false;
    }
}

