/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.conflict;

import com.orientechnologies.orient.core.conflict.OVersionRecordConflictStrategy;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSaveThreadLocal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import java.util.concurrent.atomic.AtomicInteger;

public class OAutoMergeRecordConflictStrategy
extends OVersionRecordConflictStrategy {
    public static final String NAME = "automerge";

    @Override
    public byte[] onUpdate(OStorage storage, byte iRecordType, ORecordId rid, int iRecordVersion, byte[] iRecordContent, AtomicInteger iDatabaseVersion) {
        if (iRecordType == 100) {
            OStorageOperationResult<ORawBuffer> res = storage.readRecord(rid, null, false, false, null);
            ODocument storedRecord = new ODocument(rid).fromStream(res.getResult().getBuffer());
            ODocument newRecord = (ODocument)ORecordSaveThreadLocal.getLast();
            if (newRecord == null || !newRecord.getIdentity().equals(rid)) {
                newRecord = new ODocument(rid).fromStream(iRecordContent);
            }
            storedRecord.merge(newRecord, true, true);
            iDatabaseVersion.set(Math.max(iDatabaseVersion.get(), iRecordVersion) + 1);
            return storedRecord.toStream();
        }
        this.checkVersions(rid, iRecordVersion, iDatabaseVersion.get());
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

