/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.parboiled.common.StringUtils;
import org.pegdown.FastEncoder;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.WikiLinkNode;

public class LinkRenderer {
    public Rendering render(AnchorLinkNode node) {
        String name = node.getName();
        return new Rendering('#' + name, node.getText()).withAttribute("name", name);
    }

    public Rendering render(AutoLinkNode node) {
        return new Rendering(node.getText(), node.getText());
    }

    public Rendering render(ExpLinkNode node, String text) {
        Rendering rendering = new Rendering(node.url, text);
        return StringUtils.isEmpty((String)node.title) ? rendering : rendering.withAttribute("title", FastEncoder.encode(node.title));
    }

    public Rendering render(ExpImageNode node, String text) {
        Rendering rendering = new Rendering(node.url, text);
        return StringUtils.isEmpty((String)node.title) ? rendering : rendering.withAttribute("title", FastEncoder.encode(node.title));
    }

    public Rendering render(MailLinkNode node) {
        String obfuscated = FastEncoder.obfuscate(node.getText());
        return new Rendering("mailto:" + obfuscated, obfuscated);
    }

    public Rendering render(RefLinkNode node, String url, String title, String text) {
        Rendering rendering = new Rendering(url, text);
        return StringUtils.isEmpty((String)title) ? rendering : rendering.withAttribute("title", FastEncoder.encode(title));
    }

    public Rendering render(RefImageNode node, String url, String title, String alt) {
        Rendering rendering = new Rendering(url, alt);
        return StringUtils.isEmpty((String)title) ? rendering : rendering.withAttribute("title", FastEncoder.encode(title));
    }

    public Rendering render(WikiLinkNode node) {
        try {
            String text;
            String url = text = node.getText();
            int pos = text.indexOf("|");
            if (pos >= 0) {
                url = text.substring(0, pos);
                text = text.substring(pos + 1);
            }
            url = "./" + URLEncoder.encode(url.replace(' ', '-'), "UTF-8") + ".html";
            return new Rendering(url, text);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
    }

    public static class Rendering {
        public final String href;
        public final String text;
        public final List<Attribute> attributes = new ArrayList<Attribute>(2);

        public Rendering(String href, String text) {
            this.href = href;
            this.text = text;
        }

        public Rendering withAttribute(String name, String value) {
            return this.withAttribute(new Attribute(name, value));
        }

        public Rendering withAttribute(Attribute attr) {
            this.attributes.add(attr);
            return this;
        }
    }

    public static class Attribute {
        public static final Attribute NO_FOLLOW = new Attribute("rel", "nofollow");
        public final String name;
        public final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

